% ============================================================================
% MarChemSpec Template for Artificial Seawater  (Calculation Type = 1)
%
% Purpose: Calculate state variables and thermodynamic quantities of 
% artificial seawater at different practical salinities and temperatures, 
% and determine how they respond to additions (and subtractions) of H+.
% This system is used to calibrate Harned cells in artifical seawater
% to obtain the values of the standard potential Em*.
% 
% The 'base' artificial seawater composition in MarChemSpec is that of 
% DelValls and Dickson (Deep-Sea Research I, 45, 1541-1554 (1998)), but
% Tris molality set to zero. 
%
% Further information can be found in the MarChemSpec manual.
% ============================================================================

% STEP 0: Don't forget to specify the directory that contains the MATLAB  
%         MEX file, using the addPath() command. It can also be done 
%         in this script. (Linux users: *before* starting MATLAB you must
%         make the assignments to LD_LIBRARY_PATH and LD_PRELOAD as described
%         in the manual).


% STEP 1: Assign the two directories that contain MarChemSpec data files, 
%         and the parent directory for those (ASWbuffer, and seawater) 
%         containing files of variances. They must be terminated with 
%         either a '\' (Windows) or '/' (Linux).
%    e.g. Windows: strFilesDirectory='{drive and path}\';
%         Linux:   strFilesDirectory='{path}/';

strFilesDirectory = 
strCovmxDirectory = 


% The following input variables have fixed values for these calculations
% Do not change any of these values!

%-------------------------------------------------------------------------
iCalc       = 1;   % defines the type of medium to be modelled
P           = 1;   % pressure in atmospheres. The first release 
                   % of MarChemSpec is limited to a pressure of 1 atmosphere
nSpecies    = 7;   % the row length of the arrays containing the calculated
                   % amount contents, molalities and activity coefficients
nOut        = 8;   % this is the number of state variables and 
                   % stoichiometric equilibrium constants to be returned 
%-------------------------------------------------------------------------

% STEP 2. User-defined input variables:                           
                   
tC          = 10;   % temperature in degrees Celsius (allowed range -5 to 45)
S           = 35;   % nominal salinity (allowed range >0 to 45)
mH          = 0.01; % molality of HCl substituted for NaCl in the artificial
                    % seawater recipe: mH cannot therefore exceed the Na+
                    % molality at the chosen salinity

% STEP 3: Call the code to obtain the calculated properties of the artificial 
%         seawater you have specified. The contents of the output arrays are 
%         summarised further below. Return to step 2 for more calculations, 
%         or to correct errors. 
 
[Outputs, NamesOutputs, cSpecies_out, mSpecies_out, ActCoeffs, NamesSpecies,iFail] = ...
  MarChemSpec(iCalc, tC, S, P, mH, nSpecies, nOut, strFilesDirectory,strCovmxDirectory);

% ============================================================================
%
% MARCHEMSPEC OUTPUTS, AND WHAT THEY MEAN
%
% Calls of MarChemSpec return acid-base and other properties of the
% artificial seawater being modelled, and the outputs are described in the 
% MarChemSpec documentation. Here is a summary:
%
% Outputs:      Double precision array, with two columns. The first column  
%               contains values of the variables that characterise the system 
%               modelled, and the second column their uncertainties. The
%               missing value code, for quantities not calculated, is 99.
%
% NamesOutputs: Column of shortform names for the variables in Outputs.
%
% cSpecies_out: Double precision array, with three rows, containing:
%               First row: cation amount contents (moles per kg of solution).
%               Second row: anion amount contents
%               Third row: neutral (uncharged species) amount contents.
%
% mSpecies_out: Same as cSpecies_out, but containing molalities (moles per
%               kg of pure water).
%
% Actcoeffs:    Same as cSpecies_out, but containing molality-based activity
%               coefficients.
%
% NameSpecies:  Character array with three rows, containing species names 
%               corresponding to the values in the three arrays above. 
%
% iFail:        On output, this contains error codes (a value of zero 
%               indicates complete success).
%
% ============================================================================
