% ============================================================================
% MarChemSpec Template for Standard Seawater (Calculation Type = 4)
% This template does not use the iFix>0 option for defining CO2 system
% parameters, although alkalinity can be varied using the mH
%
% Purpose: Calculate seawater properties and state variables at different 
% practical salinities and temperatures, and determine how they respond to
% additions (and subtractions) of H+ to vary alkalinity. 
% 
% The 'base' seawater composition in MarChemSpec is that of the standard 
% seawater of Millero et al. (Deep-Sea Research I, 55, 50-72 (2008)). 
%
% Further information can be found in the MarChemSpec manual.
% ============================================================================

% STEP 0: Don't forget to specify the directory that contains the MATLAB  
%         MEX file, using the addPath() command. It can also be done 
%         in this script. (Linux users: *before* starting MATLAB you must
%         make the assignments to LD_LIBRARY_PATH and LD_PRELOAD as described
%         in the manual).


% STEP 1: Assign the two directories that contain MarChemSpec data files, 
%         and the parent directory for those (ASWbuffer, and seawater) 
%         containing files of variances. They must be terminated with 
%         either a '\' (Windows) or '/' (Linux).
%    e.g. Windows: strFilesDirectory='{drive and path}\';
%         Linux:   strFilesDirectory='{path}/';

strFilesDirectory = 
strCovmxDirectory = 


% ----------------------------------------------------------------------------
% The following input variables have fixed values for these calculations.
% (Do not change any of these values!)

iCalc       = 4;           % Defines the type of medium to be modelled.
nOut        = 54;          % The number of state variables and stoichiometric
                           %   equilibrium constants to be returned.
P           = 1.0;         % Pressure (atmospheres). The first release of
                           %   MarChemSpec is limited to a pressure of 1 atm.
nSpecies    = 9;           % Row length (no. of columns) of the arrays  
                           %   containing the calculated species amount  
                           %   contents, molalities, and activity coefficients.
% -----------------------------------------------------------------------------


% STEP 2: User-defined input variables, and call function

iFix        = 0;           % No CO2 system parameters fixed by the user
ValuesFixed = [0 0; 0 0];  % No CO2 system parameters fixed by the user

tC = 25;                   % temperature (allowed range -5 to 45 C)
S  = 35;                   % practical salinity (allowed range >0 to 45)
mH = 0.0;                  % an amount content (moles per kg solution) 
                           %   of H+ that will be substituted for Na+ (or added as NaOH 
                           %   if mH is negative) as a simple way of adjusting pH and 
                           %   alkalinity. A value of zero corresponds to the seawater 
                           %   recipe of Millero et al. (2008).


[Outputs, NamesOutputs, cSpecies_out, mSpecies_out, ActCoeffs, NamesSpecies, iFail] = ...
MarChemSpec(iCalc, tC, S, P, mH, nSpecies, iFix, ValuesFixed, nOut, strFilesDirectory, strCovmxDirectory);

% ============================================================================
%
% MARCHEMSPEC OUTPUTS, AND WHAT THEY MEAN
%
% Calls of MarChemSpec return acid-base and other properties of the natural
% water being modelled, and the outputs are described in the MarChemSpec 
% documentation. Here is a summary:
%
% Outputs:      Double precision array, with two columns. The first column  
%               contains values of the variables that characterise the system 
%               modelled, and the second column their uncertainties. The
%               missing value code, for quantities not calculated, is 99.
%
%               For iCalc = 4 and 5 the outputs are state variables of the 
%               seawater or other natural water (pH, acid-base equilibrium
%               constants, calcium carbonate concentration product).
%
% NamesOutputs: Column of shortform names for the variables in Outputs.
%
% cSpecies_out: Double precision array, with three rows, containing:
%               First row: cation amount contents (moles per kg of solution).
%               Second row: anion amount contents
%               Third row: neutral (uncharged species) amount contents.
%
% mSpecies_out: Same as cSpecies_out, but containing molalities (moles per
%               kg of pure water).
%
% Actcoeffs:    Same as cSpecies_out, but containing molality-based activity
%               coefficients.
%
% NameSpecies:  Character array with three rows, containing species names 
%               corresponding to the values in the three arrays above. 
%
% iFail:        On output, this contains error codes (a value of zero 
%               indicates complete success).
%
% ============================================================================

